/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.io.File;
import java.util.List;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.vfs.AdditiveCache;
import org.gradle.internal.vfs.AdditiveCacheLocations;

public class DefaultAdditiveCacheLocations
implements AdditiveCacheLocations {
    private final FileHierarchySet additiveCacheRoots;

    public DefaultAdditiveCacheLocations(List<AdditiveCache> fileStores) {
        FileHierarchySet additiveCacheRoots = DefaultFileHierarchySet.of();
        for (AdditiveCache fileStore : fileStores) {
            for (File file : fileStore.getAdditiveCacheRoots()) {
                additiveCacheRoots = additiveCacheRoots.plus(file);
            }
        }
        this.additiveCacheRoots = additiveCacheRoots;
    }

    @Override
    public boolean isInsideAdditiveCache(String path) {
        return this.additiveCacheRoots.contains(path);
    }
}

